<!DOCTYPE html>
<html <?php language_attributes(); ?>>
<head>
	<meta charset="<?php bloginfo( 'charset' ); ?>" />
	<?php if ($GLOBALS['mobile']) { ?><meta name="viewport" content="width=device-width" /><?php echo "\n"; } ?><link rel="pingback" href="<?php bloginfo( 'pingback_url' ); ?>">
	<link rel="icon" type="image/ico" href="<?php echo get_stylesheet_directory_uri(); ?>/favicon.ico"/>

<!-- WP Head Info -->
<?php wp_head(); ?>
<!-- End WP Head Info -->

</head>

<body <?php

$class = (get_field('splash_page', 'options') && is_front_page()) ? 'splash' : '';
body_class($class);

?>>

	<div id="mainwrapper">

		<?php if ( !get_field('splash_page', 'options') && ! is_front_page() ) { ?>
			<?php get_template_part( 'inc/nav' ); ?>
		<?php } ?>
		<nav id="mobilenav" role="navigation">
			<div id="mobilenav_wrapper">
				<div class="row">
					<div class="grid_12">
						<div class="table">
							<div class="logo">
								<a href="<?php echo home_url(); ?>"><img src="<?php echo get_stylesheet_directory_uri(); ?>/img/mobile-logo.png" alt="<?php bloginfo('name'); ?>" /></a>
							</div>
							<div class="link">
								<a href="#" id="mobilebutton"><i class="fa fa-bars"></i><span>Menu</span></a>
							</div>
						</div>
					</div>
				</div>
			</div>
			<div id="mobilemenu" style="display: none;">
				<div class="row">
					<div class="grid_12">
						<?php wp_nav_menu(array('theme_location' => 'main')); ?>
					</div>
				</div>
			</div>
		</nav>
		<div id="maincontent">