// Mobile Navigation
function mobileNav() {
	jQuery('#mobilebutton').click(function(e) {
		e.preventDefault();
		jQuery('#mobilemenu').slideToggle(
			'fast',
			function() {
				jQuery('#mobilemenu .sub-menu').each(function() {
					if (jQuery(this).css('display') === 'block') {
						jQuery(this).css('display', 'none');
					}
				});
			}
		);
	});
	jQuery('#mobilemenu .menu > li > a').click(function(e) {
		if (jQuery(this).attr('href') === '#') {
			e.preventDefault();
			jQuery('#mobilemenu .sub-menu').each(function() {
				if (jQuery(this).css('display') === 'block') {
					jQuery(this).slideToggle();
				}
			});
			if (jQuery(this).next().css('display') !== 'block') {
				jQuery(this).next().slideToggle();
			}
		}
	});

	//add client-portal button to mobile nav.
	jQuery( ".client-portal" ).clone().appendTo( "#mobilenav .menu" );
	jQuery( "#mobilenav .client-portal" ).wrap( "<li class='menu-item mobile-client-portal'></li>" );
	jQuery( "#mobilenav .mobile-client-portal a" ).removeClass('client-portal');


}

function parallax() {
	if (jQuery(window).width() > 767) {
		jQuery('.bg-section').each(function(){
			scrollTop     = jQuery(window).scrollTop(),
			elementOffset = jQuery(this).offset().top,
			distance      = (elementOffset - scrollTop);
			jQuery(this).css('background-position', 'center ' + distance/2 + 'px');
		});
	}
}

jQuery( document ).ready(function() {



	//HOME
	if (jQuery('body').hasClass('home')) {
		var distance = jQuery('#mainheader').offset().top;
		var w = jQuery(window);

		w.scroll(function() {
			if ( w.scrollTop() >= distance ) {
				jQuery('#mainheader').addClass('sticky');
			} else {
				jQuery('#mainheader').removeClass('sticky');
			}
		});
	}

	//NOT HOME
	if (!jQuery('body').hasClass('home')) {
		//parallax, not on front-page
		parallax();
		jQuery(window).scroll(function() {
			parallax();
		});
	}

	//BLOG
	if (jQuery('body').hasClass('blog')) {
		// if url doesn't contain the characters "/page/" then change the text on pagination
		var url = window.location.href;
		if( url.indexOf("/page/") === -1 ) {
			jQuery('.pagination a').text('See More Posts');
		}
	}

	//GALLERY
	if (jQuery('body').hasClass('post-type-archive-gallery_cpt') || jQuery('body').hasClass('tax-gcategory') ) {
		var url;
		function load_gallery() {
			jQuery('#gallery-ajax').load(url +' #gallery-wrapper',function(){
				//this function removes the old pagination, and loads the new, 
				//so script needs to be called again.
				do_gallery_ajax();
			});
		}
		function do_gallery_ajax() {
			jQuery('#gallery-wrapper').fadeTo( 1000 , 1);
			jQuery( ".pagination a" ).click(function(event) {
				event.preventDefault();
				jQuery('#gallery-wrapper').fadeTo( 2000 , 0);
				jQuery('html, body').animate({
					scrollTop: jQuery("#categories").offset().top
				}, 2000);
				url = jQuery(this).attr('href');
				setTimeout(load_gallery, 1500);
			});
		}
		do_gallery_ajax();
	}
	mobileNav();

});