<?php
/*
Template Name: Flex Template
*/
?>
<?php get_header(); ?>

<?php get_template_part( 'inc/pageheader' ); ?>

			<div class="pagecontent">

				<section id="hero" <?php echo get_bg('hero_background'); ?> class="bg-section blue">
					<div class="overlay">
						<div class="row">
							<div class="grid_12">
								<h3 class="border"><span><?php the_title() ?></span></h3>
							</div>
						</div>
					</div>
				</section>
<?php
	if( have_rows('sections') ):
		while ( have_rows('sections') ) : the_row();
			if( get_row_layout() == 'flex_content' ):
?>
				<section class="flex-content">
					<div class="row">
						<div class="grid_12">
							<?php if( get_sub_field('content') ) { ?>
								<?php the_sub_field('content'); ?>
							<?php } ?>
						</div>
					</div>
				</section>
<?php
			elseif( get_row_layout() == 'text_w_sidebar_img' ):
				//sidebar
				$bg = get_sub_bg('sidebar_image');
				$sidebar = '
					<div class="grid_4">
						<div class="sidebar-image" '. $bg .'></div>
					</div>
				';
				if( get_sub_field('sidebar_align') == 'left' ) {
					$left_sidebar = $sidebar;
					$right_sidebar = '';
				} else {
					$right_sidebar = $sidebar;
					$left_sidebar = '';
				}
				$overlay_color = ( get_sub_field('background_image') ? get_sub_field('overlay_color') : '' );
?>
				<section class="text-w-sidebar-img bg-section <?php echo $overlay_color; ?>" <?php echo get_sub_bg('background_image'); ?>>
					<div class="overlay">
						<div class="row">
							<?php echo $left_sidebar; ?>
							<div class="grid_8">
								<?php if( get_sub_field('headline') ) { ?>
									<h3 class="border"><span><?php the_sub_field('headline') ?></span></h3>
								<?php } ?>
								<?php if( get_sub_field('text') ) { ?>
									<p><?php the_sub_field('text') ?></p>
								<?php } ?>
<?php
	if( have_rows('buttons') ):
		while ( have_rows('buttons') ) : the_row();

			echo get_sub_btn_internal_external('button_url_type', 'internal_page_link', 'external_page_link', 'button_text', 'btn border');	
						
		endwhile;
	else :
		// no rows found
	endif;
?>						
							</div>
							<?php echo $right_sidebar; ?>
						</div>
					</div>
				</section>
<?php
			elseif( get_row_layout() == 'text_w_sidebar_btns' ):
				if( have_rows('sidebar_buttons') ):
					$sidebar_buttons = '';
					while ( have_rows('sidebar_buttons') ) : the_row();

						$sidebar_buttons .= get_sub_btn_internal_external('button_url_type', 'internal_page_link', 'external_page_link', 'button_text', 'btn border');				
					endwhile;
				else :
					// no rows found
				endif;

				$sidebar = '<div class="grid_4">'. $sidebar_buttons .'</div>';

				if( get_sub_field('sidebar_align') == 'left' ) {
					$left_sidebar = $sidebar;
					$right_sidebar = '';
				} else {
					$right_sidebar = $sidebar;
					$left_sidebar = '';
				}
				$overlay_color = ( get_sub_field('background_image') ? get_sub_field('overlay_color') : '' );
?>
				<section class="text-w-sidebar-btns bg-section <?php echo $overlay_color; ?>" <?php echo get_sub_bg('background_image'); ?>>
					<div class="overlay">
						<?php if( get_sub_field('headline') ) { ?>
							<div class="row">
								<div class="grid_12">
									<h3 class="border"><span><?php the_sub_field('headline') ?></span></h3>
								</div>
							</div>
						<?php } ?>
						<div class="row">
							<?php echo $left_sidebar; ?>
							<div class="grid_8">
								<?php if( get_sub_field('text') ) { ?>
									<p><?php the_sub_field('text') ?></p>
								<?php } ?>
							</div>
							<?php echo $right_sidebar; ?>
						</div>
					</div>
				</section>
<?php
			endif;
		endwhile;
	else :
		// no layouts found
	endif;
?>
				


			</div> <!-- .pagecontent -->

<?php get_footer(); ?>